// Title      : Reliability.java
// Author     : James Baird
// Created    : Monday, 24th November 2003

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;

public class Reliability
{
  public static void main(String[] args)
  {
    if (args.length == 3)
      reliability(args[0], args[1], Integer.parseInt(args[2]));
  }

  protected static void reliability(String infileName, String outfileName, int count)
  {
    try
    {
      Random random = new Random();

      Hashtable numbers = new Hashtable();
    
      BufferedReader infile = new BufferedReader(new FileReader(infileName));
      
      String line = infile.readLine();
      while (line != null)
      {
        int number = Integer.parseInt(line);
        
        numbers.put(new Integer(number), "");
      
        line = infile.readLine();
      }
      
      infile.close();
    
      FileWriter outfile = new FileWriter(outfileName);
      
      for (int i = 0; i < count; i++)
      {
        Integer n = null;
        
        do
          n = new Integer(((int)(random.nextDouble() * 200.0)) + 1);
        while (numbers.get(n) != null);
        
        numbers.put(n, "");
        
        outfile.write(n + System.getProperty("line.separator"));
      }
      
      outfile.flush();
      outfile.close();
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }  
}
